<?php
require_once __DIR__.'/includes/db.php';
require_once __DIR__.'/includes/helpers.php';
require_login_customer();

$code = $_GET['code'] ?? '';
$st = $pdo->prepare("
  SELECT o.*, k.name AS kit_name, t.name AS theme_name, c.full_name, c.phone
  FROM orders o
  JOIN kits k ON k.id=o.kit_id
LEFT JOIN themes t ON t.id=o.theme_id
  JOIN customers c ON c.id=o.customer_id
  WHERE o.code=? LIMIT 1
");
$st->execute([$code]);
$o = $st->fetch();
if(!$o) exit("Pedido não encontrado.");

$st2 = $pdo->prepare("
  SELECT i.name AS item_name, v.variant_name, oc.qty
  FROM order_customizations oc
  JOIN items i ON i.id=oc.item_id
  JOIN item_variants v ON v.id=oc.variant_id
  WHERE oc.order_id=?
  ORDER BY oc.id ASC
");
$st2->execute([(int)$o['id']]);
$custom = $st2->fetchAll();

$msg =
"Olá! Pedido {$o['code']} registrado ✅\n".
"Kit: {$o['kit_name']}\n".
"Retirada: {$o['pickup_at']} | Devolução: {$o['return_at']}\n".
"Tema: {$o['theme_text']}\n".
"Total: R$ ".number_format((float)$o['total_value'],2,',','.')."\n".
"Sinal (50%): R$ ".number_format((float)$o['deposit_required'],2,',','.')."\n".
"Me envie o comprovante do sinal por aqui, por favor. 💖";
?><!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="assets/style.css"><title>Pedido <?=h($o['code'])?></title></head><body>
<header class="brandbar">
  <a class="logo" href="index.php">
    <img src="assets/logo.webp" alt="Flor de Liz">
    <div class="logo-text">
      <div class="logo-title">Flor de Liz</div>
      <div class="logo-sub">Mini pegue e monte</div>
    </div>
  </a>
  <div class="brand-actions">
    <a class="badge" href="meus_pedidos.php">Meus pedidos</a> <a class="badge" href="logout.php">Sair</a>
  </div>
</header>
<div class="container">
  <div class="top"><h2>Pedido <?=h($o['code'])?></h2><a class="badge" href="meus_pedidos.php">Voltar</a></div>

  <div class="card">
    <div class="badge"><?=h($o['status'])?></div>
    <div class="badge"><?=h($o['payment_status'])?></div>
    <h3 style="margin:10px 0 6px 0"><?=h($o['kit_name'])?></h3>
    <div class="small">Tema: <b><?=h(!empty($o['theme_name'])?$o['theme_name']:$o['theme_text'])?></b></div>
    <div class="small">Retirada: <b><?=h($o['pickup_at'])?></b> • Devolução: <b><?=h($o['return_at'])?></b></div>
    <div class="small">Total: <b>R$ <?=number_format((float)$o['total_value'],2,',','.')?></b> • Sinal(50%): <b>R$ <?=number_format((float)$o['deposit_required'],2,',','.')?></b></div>
    <div style="margin-top:12px">
      <a class="badge" target="_blank" href="<?=h(wa_link($o['phone'], $msg))?>">Enviar no WhatsApp</a>
    </div>
  </div>

  <div class="card">
    <h3 style="margin-top:0">Cores escolhidas</h3>
    <?php foreach($custom as $c): ?>
      <div class="small">• <?=h($c['item_name'])?>: <b><?=h($c['variant_name'])?></b> (<?= (int)$c['qty']?>)</div>
    <?php endforeach; ?>
    <?php if(!$custom): ?><div class="small">Sem itens customizáveis.</div><?php endif; ?>
  </div>
</div></body></html>
