<?php
require_once __DIR__.'/includes/db.php';
require_once __DIR__.'/includes/helpers.php';
require_login_customer();

session_start_safe();
$cid = (int)$_SESSION['customer_id'];

$st = $pdo->prepare("SELECT code, event_date, status, payment_status, total_value, deposit_required, created_at FROM orders WHERE customer_id=? ORDER BY id DESC");
$st->execute([$cid]);
$rows = $st->fetchAll();
?><!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="assets/style.css"><title>Meus pedidos</title></head><body>
<header class="brandbar">
  <a class="logo" href="index.php">
    <img src="assets/logo.webp" alt="Flor de Liz">
    <div class="logo-text">
      <div class="logo-title">Flor de Liz</div>
      <div class="logo-sub">Mini pegue e monte</div>
    </div>
  </a>
  <div class="brand-actions">
    <a class="badge" href="meus_pedidos.php">Meus pedidos</a> <a class="badge" href="logout.php">Sair</a>
  </div>
</header>
<div class="container">
  <div class="top"><h2>Meus pedidos</h2><a class="badge" href="index.php">Novo pedido</a></div>
  <?php foreach($rows as $r): ?>
    <div class="card">
      <div class="top">
        <div>
          <div class="badge"><?=h($r['status'])?></div>
          <div class="badge"><?=h($r['payment_status'])?></div>
          <div style="margin-top:8px"><b><?=h($r['code'])?></b></div>
          <div class="small">Evento: <?=h($r['event_date'])?> • Total: R$ <?=number_format((float)$r['total_value'],2,',','.')?> • Sinal: R$ <?=number_format((float)$r['deposit_required'],2,',','.')?></div>
        </div>
        <a class="badge" href="pedido.php?code=<?=h($r['code'])?>">Ver</a>
      </div>
    </div>
  <?php endforeach; ?>
  <?php if(!$rows): ?><div class="card">Você ainda não tem pedidos.</div><?php endif; ?>
</div></body></html>
