<?php
require_once __DIR__.'/includes/db.php';
require_once __DIR__.'/includes/csrf.php';
require_once __DIR__.'/includes/auth_customer.php';
require_once __DIR__.'/includes/helpers.php';

$msg='';
if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  $ok = customer_login($pdo, trim($_POST['phone']??''), $_POST['pass']??'');
  if ($ok) redirect('index.php');
  $msg = 'Login inválido.';
}
?><!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="assets/style.css"><title>Login - Flor de Liz</title></head><body>
<header class="brandbar">
  <a class="logo" href="index.php">
    <img src="assets/logo.webp" alt="Flor de Liz">
    <div class="logo-text">
      <div class="logo-title">Flor de Liz</div>
      <div class="logo-sub">Mini pegue e monte</div>
    </div>
  </a>
  <div class="brand-actions">
    <a class="badge" href="cadastro.php">Criar conta</a>
  </div>
</header>
<div class="container">
  <div class="top"><h2>Entrar</h2><a class="badge" href="cadastro.php">Criar conta</a></div>
  <?php if($msg): ?><div class="card"><?=h($msg)?></div><?php endif; ?>
  <form class="card" method="post">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <label>WhatsApp</label><input name="phone" required>
    <label>Senha</label><input type="password" name="pass" required>
    <button>Entrar</button>
  </form>
  <div class="card small">Painel admin: <a href="admin/login.php">/admin</a></div>
</div></body></html>
