<?php
require_once __DIR__.'/includes/db.php';
require_once __DIR__.'/includes/helpers.php';
require_once __DIR__.'/includes/availability.php';

require_login_customer();

$kit_id = (int)($_GET['id'] ?? 0);
$pickup_date = $_GET['pickup_date'] ?? '';
$pickup_time = $_GET['pickup_time'] ?? '10:00';

$st = $pdo->prepare("SELECT id,name,price,photo_path FROM kits WHERE id=? AND active=1 LIMIT 1");
$st->execute([$kit_id]);
$kit = $st->fetch();
if(!$kit) exit("Kit inválido.");

$step = 1;
$pickup_at = '';
$return_at = '';

if ($pickup_date && $pickup_time) {
  $pickup_at = trim($pickup_date.' '.$pickup_time);
  if (!pickup_min_time_ok($pickup_at)) {
    $pickup_at = '';
  } else {
    $pickupDT = DateTime::createFromFormat('Y-m-d H:i', $pickup_at, new DateTimeZone(date_default_timezone_get()));
    if ($pickupDT) {
      $returnDT = (clone $pickupDT)->modify('+48 hours');
      $return_at = $returnDT->format('Y-m-d H:i');
      $step = 2;
    } else {
      $pickup_at = '';
    }
  }
}

$themes = $pdo->query("SELECT id,name,image_path FROM themes WHERE active=1 ORDER BY name ASC")->fetchAll();

$st = $pdo->prepare("
  SELECT ki.item_id, ki.qty, ki.customizable, i.name AS item_name, i.category, i.image_path
  FROM kit_items ki
  JOIN items i ON i.id=ki.item_id
  WHERE ki.kit_id=?
  ORDER BY i.category, i.name
");
$st->execute([$kit_id]);
$comp = $st->fetchAll();

?><!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="assets/style.css">
<title><?=h($kit['name'])?> • Flor de Liz</title>
</head><body>
<header class="brandbar">
  <a class="logo" href="index.php">
    <img src="assets/logo.webp" alt="Flor de Liz">
    <div class="logo-text">
      <div class="logo-title">Flor de Liz</div>
      <div class="logo-sub">Mini pegue e monte</div>
    </div>
  </a>
  <div class="brand-actions">
    <a class="badge" href="index.php">Kits</a>
    <a class="badge" href="meus_pedidos.php">Meus pedidos</a>
    <a class="badge" href="logout.php">Sair</a>
  </div>
</header>

<div class="container">
  <div class="top">
    <div>
      <h2><?=h($kit['name'])?></h2>
      <div class="small">Etapa <?=$step?> de 2 • Retirada a partir das 10h • Devolução automática em 48h</div>
    </div>
    <div>
      <a class="badge" href="index.php">Trocar kit</a>
    </div>
  </div>

  <div class="card kit-card">
    <?php if(!empty($kit['photo_path'])): ?>
      <img class="kit-cover" src="<?=h($kit['photo_path'])?>" alt="<?=h($kit['name'])?>">
    <?php endif; ?>
    <div class="top" style="align-items:flex-start">
      <div>
        <div class="badge">R$ <?=number_format((float)$kit['price'],2,',','.')?></div>
        <div style="margin-top:8px"><b><?=h($kit['name'])?></b></div>
        <div class="small">Escolha o kit primeiro. Agora selecione a data/horário e depois personalize.</div>
      </div>
    </div>
  </div>

  <?php if($step===1): ?>
    <form class="card" method="get">
      <input type="hidden" name="id" value="<?=$kit_id?>">
      <div class="grid grid2">
        <div><label>Data da retirada</label><input type="date" name="pickup_date" value="<?=h($pickup_date)?>" required></div>
        <div><label>Hora da retirada (a partir 10:00)</label><input type="time" name="pickup_time" value="<?=h($pickup_time)?>" min="10:00" required></div>
      </div>
      <button style="margin-top:10px">Continuar</button>
      <div class="small" style="margin-top:8px">A devolução será automaticamente 48h após o horário de retirada.</div>
    </form>
  <?php else: ?>

    <form class="card" method="post" action="checkout.php">
      <input type="hidden" name="kit_id" value="<?=$kit_id?>">
      <input type="hidden" name="pickup_at" value="<?=h($pickup_at)?>">
      <input type="hidden" name="return_at" value="<?=h($return_at)?>">

      <div class="grid grid2">
        <div>
          <label>Retirada</label>
          <input value="<?=h($pickup_at)?>" disabled>
        </div>
        <div>
          <label>Devolução (+48h)</label>
          <input value="<?=h($return_at)?>" disabled>
        </div>
      </div>

      <div class="grid grid2" style="margin-top:10px">
        <div>
          <label>Retirada por</label>
          <select name="pickup_mode" required>
            <option value="client">Cliente</option>
            <option value="app">Uber/99</option>
          </select>
        </div>
        <div>
          <label>Devolução por</label>
          <select name="return_mode" required>
            <option value="client">Cliente</option>
            <option value="app">Uber/99</option>
          </select>
        </div>
      </div>

      <h3 style="margin:14px 0 6px 0">Escolha o tema</h3>
      <div class="small">Selecione um tema da lista. Você pode cadastrar/atualizar temas no painel admin.</div>

      <?php if(!$themes): ?>
        <div class="small" style="margin-top:8px">Nenhum tema cadastrado. Cadastre no admin para aparecer aqui.</div>
      <?php else: ?>
        <div class="grid grid2" style="margin-top:10px">
          <?php foreach($themes as $t): ?>
            <label class="card" style="margin:0; cursor:pointer">
              <input type="radio" name="theme_id" value="<?=$t['id']?>" required>
              <?php if(!empty($t['image_path'])): ?>
                <img class="kit-cover" style="height:160px" src="<?=h($t['image_path'])?>" alt="<?=h($t['name'])?>">
              <?php endif; ?>
              <div style="margin-top:8px"><b><?=h($t['name'])?></b></div>
            </label>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>

      <h3 style="margin:16px 0 6px 0">Cores dos itens</h3>
      <div class="small">As opções abaixo já consideram a disponibilidade de cores no período escolhido.</div>

      <div class="grid" style="margin-top:12px">
        <?php foreach($comp as $c):
          $item_id = (int)$c['item_id'];
          $qty_needed = (int)$c['qty'];
          $custom = (int)$c['customizable']===1;
        ?>
          <div class="card" style="margin:0">
            <div class="top" style="align-items:flex-start">
              <div>
                <div class="badge"><?=h($c['category'])?></div>
                <div style="margin-top:8px"><b><?=h($c['item_name'])?></b></div>
                <div class="small">Quantidade no kit: <?= (int)$qty_needed ?></div>
              </div>
            </div>

            <?php if(!empty($c['image_path'])): ?>
              <img class="kit-cover" style="height:160px" src="<?=h($c['image_path'])?>" alt="<?=h($c['item_name'])?>">
            <?php endif; ?>

            <?php if($custom): 
              $opts = available_variants_for_item($pdo, $item_id, $qty_needed, $pickup_at, $return_at);
            ?>
              <label style="margin-top:10px">Cor</label>
              <?php if(!$opts): ?>
                <div class="small">Sem cores disponíveis para este item no período escolhido.</div>
              <?php else: ?>
                <select name="choice[<?=$item_id?>]" required>
                  <option value="">Selecione</option>
                  <?php foreach($opts as $o): ?>
                    <option value="<?=$o['id']?>"><?=h($o['name'])?> (disp: <?=$o['avail']?>)</option>
                  <?php endforeach; ?>
                </select>
              <?php endif; ?>
            <?php else: ?>
              <div class="small" style="margin-top:10px">Este item é fixo no kit.</div>
            <?php endif; ?>
          </div>
        <?php endforeach; ?>
      </div>

      <label style="margin-top:12px">Observações (opcional)</label>
      <textarea name="notes" rows="3" placeholder="Ex: cores preferidas, detalhes, etc."></textarea>

      <button style="margin-top:12px">Finalizar pedido</button>
      <div class="small" style="margin-top:8px">Ao finalizar, você verá o total e o sinal (50%) e poderá enviar no WhatsApp.</div>
    </form>

  <?php endif; ?>

</div>
</body></html>
