<?php
require_once __DIR__.'/includes/db.php';
require_once __DIR__.'/includes/helpers.php';
require_login_customer();

$kits = $pdo->query("SELECT id,name,price,photo_path FROM kits WHERE active=1 ORDER BY price ASC")->fetchAll();

?><!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="assets/style.css"><title>Flor de Liz - Agendamento</title></head><body>
<header class="brandbar">
  <a class="logo" href="index.php">
    <img src="assets/logo.webp" alt="Flor de Liz">
    <div class="logo-text">
      <div class="logo-title">Flor de Liz</div>
      <div class="logo-sub">Mini pegue e monte</div>
    </div>
  </a>
  <div class="brand-actions">
    <a class="badge" href="meus_pedidos.php">Meus pedidos</a> <a class="badge" href="logout.php">Sair</a>
  </div>
</header>
<div class="container">
  <div class="top">
    <div>
      <h2>Agendar Kit</h2>
      <div class="small">Escolha um kit e depois selecione data/hora • Devolução automática em 48h</div>
    </div>
    <div>
      <a class="badge" href="meus_pedidos.php">Meus pedidos</a>
      <a class="badge" href="logout.php">Sair</a>
    </div>
  </div>

  <?php foreach($kits as $k): ?>
    <div class="card kit-card">
      <?php if(!empty($k['photo_path'])): ?>
        <img class="kit-cover" src="<?=h($k['photo_path'])?>" alt="<?=h($k['name'])?>">
      <?php endif; ?>
      <div class="top" style="align-items:flex-start">
        <div>
          <div class="badge">R$ <?=number_format((float)$k['price'],2,',','.')?></div>
          <h3 style="margin:10px 0 0 0"><?=h($k['name'])?></h3>
          <div class="small">Escolha o kit e personalize as cores.</div>
        </div>
        <div>
          <a class="badge" href="kit.php?id=<?=(int)$k['id']?>">Selecionar</a>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
</div></body></html>
