<?php
declare(strict_types=1);

function h(string $s): string { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

function redirect(string $to): void { header("Location: $to"); exit; }

function now_br(): string { return (new DateTime('now', new DateTimeZone(date_default_timezone_get())))->format('Y-m-d H:i:s'); }

function code_gen(string $prefix='FDL'): string {
  $chars = 'ABCDEFGHJKMNPQRSTUVWXYZ23456789';
  $r = '';
  for($i=0;$i<5;$i++) $r .= $chars[random_int(0, strlen($chars)-1)];
  return $prefix.'-'.$r;
}

function require_post(): void {
  if ($_SERVER['REQUEST_METHOD'] !== 'POST') { http_response_code(405); exit("Método inválido."); }
}

function pickup_min_time_ok(string $pickup_dt): bool {
  $dt = DateTime::createFromFormat('Y-m-d H:i', $pickup_dt, new DateTimeZone(date_default_timezone_get()));
  if (!$dt) return false;
  $h = (int)$dt->format('H');
  return $h >= 10;
}

function session_start_safe(): void {
  if (session_status() !== PHP_SESSION_ACTIVE) session_start();
}

function require_login_customer(): void {
  session_start_safe();
  if (empty($_SESSION['customer_id'])) redirect('login.php');
}

function require_login_admin(): void {
  session_start_safe();
  if (empty($_SESSION['admin_id'])) redirect('login.php');
}

function wa_link(string $phone, string $msg): string {
  $digits = preg_replace('/\D+/', '', $phone);
  // se o usuário já colocar com 55, mantém
  if (strlen($digits) === 11) $digits = '55'.$digits;
  return "https://wa.me/$digits?text=" . rawurlencode($msg);
}
