<?php
declare(strict_types=1);
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/helpers.php';

function customer_login(PDO $pdo, string $phone, string $password): bool {
  session_start_safe();
  $st = $pdo->prepare("SELECT id, password_hash FROM customers WHERE phone=? LIMIT 1");
  $st->execute([$phone]);
  $u = $st->fetch();
  if (!$u || !password_verify($password, $u['password_hash'])) return false;

  $_SESSION['customer_id'] = (int)$u['id'];
  $pdo->prepare("UPDATE customers SET last_login_at=? WHERE id=?")->execute([now_br(), $u['id']]);
  return true;
}

function customer_register(PDO $pdo, string $name, string $phone, string $password): array {
  $name = trim($name); $phone = trim($phone);
  if ($name === '' || $phone === '' || strlen($password) < 6) return [false, "Preencha tudo (senha min 6)."];

  $hash = password_hash($password, PASSWORD_DEFAULT);
  try {
    $pdo->prepare("INSERT INTO customers (full_name, phone, password_hash) VALUES (?,?,?)")
        ->execute([$name, $phone, $hash]);
    return [true, "OK"];
  } catch (Throwable $e) {
    return [false, "Telefone já cadastrado."];
  }
}
