<?php
declare(strict_types=1);
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/helpers.php';

function admin_login(PDO $pdo, string $user, string $pass): bool {
  session_start_safe();
  $st = $pdo->prepare("SELECT id, password_hash FROM admin_users WHERE username=? LIMIT 1");
  $st->execute([$user]);
  $a = $st->fetch();
  if (!$a || !password_verify($pass, $a['password_hash'])) return false;
  $_SESSION['admin_id'] = (int)$a['id'];
  return true;
}
