<?php
require_once __DIR__.'/includes/db.php';
require_once __DIR__.'/includes/helpers.php';
require_once __DIR__.'/includes/availability.php';

require_login_customer();
require_post();

session_start_safe();
$customer_id = (int)$_SESSION['customer_id'];

$kit_id = (int)($_POST['kit_id'] ?? 0);
$pickup_at = trim($_POST['pickup_at'] ?? '');
$return_at = trim($_POST['return_at'] ?? '');
$theme_id = (int)($_POST['theme_id'] ?? 0);
$theme_text = '';
$pickup_mode = $_POST['pickup_mode'] ?? 'client';
$return_mode = $_POST['return_mode'] ?? 'client';
$notes = trim($_POST['notes'] ?? '');

if ($theme_id<=0) exit("Tema é obrigatório.");
if (!pickup_min_time_ok($pickup_at)) exit("Retirada deve ser a partir das 10h.");


$th = $pdo->prepare("SELECT id,name FROM themes WHERE id=? AND active=1 LIMIT 1");
$th->execute([$theme_id]);
$thRow = $th->fetch();
if(!$thRow) exit("Tema inválido.");
$theme_text = (string)$thRow['name'];

$choices = $_POST['choice'] ?? [];
$choices = is_array($choices) ? $choices : [];
$event_date = substr($pickup_at, 0, 10);

$kit = $pdo->prepare("SELECT id, name, price FROM kits WHERE id=? AND active=1 LIMIT 1");
$kit->execute([$kit_id]);
$kitRow = $kit->fetch();
if(!$kitRow) exit("Kit inválido.");

[$ok,$msg] = validate_kit_choices($pdo, $kit_id, array_map('intval',$choices), $pickup_at, $return_at);
if(!$ok) exit(h($msg));

try {
  $pdo->beginTransaction();

  $code = code_gen('FDL');
  $kit_price = (float)$kitRow['price'];
  $total = $kit_price;
  $deposit = round($total * 0.5, 2);

  $ins = $pdo->prepare("
    INSERT INTO orders
      (code, customer_id, event_date, theme_text, theme_id, pickup_mode, return_mode, pickup_at, return_at,
       kit_id, kit_price, total_value, deposit_required, payment_status, status, notes)
    VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)
  ");
  $ins->execute([
    $code, $customer_id, $event_date, $theme_text, $theme_id,
  $pickup_mode, $return_mode,
    $pickup_at, $return_at, $kit_id, $kit_price, $total, $deposit, 'unpaid', 'pending', $notes
  ]);

  $order_id = (int)$pdo->lastInsertId();

  $st = $pdo->prepare("SELECT item_id, qty FROM kit_items WHERE kit_id=? AND customizable=1");
  $st->execute([$kit_id]);
  $rows = $st->fetchAll();

  $insC = $pdo->prepare("INSERT INTO order_customizations (order_id, item_id, variant_id, qty) VALUES (?,?,?,?)");
  foreach ($rows as $r) {
    $item_id = (int)$r['item_id'];
    $qty_needed = (int)$r['qty'];
    $variant_id = (int)($choices[$item_id] ?? 0);
    $insC->execute([$order_id, $item_id, $variant_id, $qty_needed]);
  }

  $pdo->commit();
  redirect("pedido.php?code=".$code);

} catch (Throwable $e) {
  $pdo->rollBack();
  http_response_code(500);
  exit("Erro ao salvar pedido.");
}
