<?php
require_once __DIR__.'/includes/db.php';
require_once __DIR__.'/includes/csrf.php';
require_once __DIR__.'/includes/auth_customer.php';
require_once __DIR__.'/includes/helpers.php';

$msg = '';
if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  [$ok,$m] = customer_register($pdo, $_POST['name']??'', $_POST['phone']??'', $_POST['pass']??'');
  if ($ok) { redirect('login.php'); }
  $msg = $m;
}
?><!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="assets/style.css"><title>Cadastro - Flor de Liz</title></head><body>
<header class="brandbar">
  <a class="logo" href="index.php">
    <img src="assets/logo.webp" alt="Flor de Liz">
    <div class="logo-text">
      <div class="logo-title">Flor de Liz</div>
      <div class="logo-sub">Mini pegue e monte</div>
    </div>
  </a>
  <div class="brand-actions">
    <a class="badge" href="login.php">Entrar</a>
  </div>
</header>
<div class="container">
  <div class="top"><h2>Criar conta</h2><a class="badge" href="login.php">Já tenho conta</a></div>
  <?php if($msg): ?><div class="card"><?=h($msg)?></div><?php endif; ?>
  <form class="card" method="post">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <div class="grid grid2">
      <div><label>Nome completo</label><input name="name" required></div>
      <div><label>WhatsApp</label><input name="phone" required placeholder="ex: 21999999999"></div>
    </div>
    <label>Senha (mín 6)</label><input type="password" name="pass" required>
    <button>Cadastrar</button>
    <div class="small">Após cadastrar, faça login para agendar.</div>
  </form>
</div></body></html>
