<?php
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/helpers.php';
require_once __DIR__.'/../includes/csrf.php';
require_login_admin();

$item_id = (int)($_GET['item_id'] ?? 0);

if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  $mode = $_POST['mode'] ?? 'add';
  if ($mode==='add') {
    $item = (int)($_POST['item_id'] ?? 0);
    $name = trim($_POST['variant_name'] ?? '');
    $stock = (int)($_POST['stock_qty'] ?? 0);
    if($item>0 && $name!=='') {
      $pdo->prepare("INSERT INTO item_variants (item_id, variant_name, stock_qty, active) VALUES (?,?,?,1)
                     ON DUPLICATE KEY UPDATE stock_qty=VALUES(stock_qty), active=1")
          ->execute([$item, $name, $stock]);
    }
    redirect('variants.php?item_id='.$item);
  }
  if ($mode==='del') {
    $id = (int)($_POST['id'] ?? 0);
    $pdo->prepare("DELETE FROM item_variants WHERE id=?")->execute([$id]);
    redirect('variants.php?item_id='.$item_id);
  }
}

$items = $pdo->query("SELECT id,name FROM items ORDER BY name ASC")->fetchAll();
$vars = [];
if($item_id>0){
  $st = $pdo->prepare("SELECT * FROM item_variants WHERE item_id=? ORDER BY variant_name ASC");
  $st->execute([$item_id]);
  $vars = $st->fetchAll();
}
?><!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="../assets/style.css"><title>Cores</title></head><body>
<header class="brandbar">
  <a class="logo" href="dashboard.php">
    <img src="../assets/logo.webp" alt="Flor de Liz">
    <div class="logo-text">
      <div class="logo-title">Flor de Liz</div>
      <div class="logo-sub">Mini pegue e monte</div>
    </div>
  </a>
  <div class="brand-actions">
    <a class="badge" href="dashboard.php">Dashboard</a> <a class="badge" href="orders.php">Pedidos</a> <a class="badge" href="logout.php">Sair</a>
  </div>
</header>
<div class="container">
  <div class="top"><h2>Cores (Variações)</h2><a class="badge" href="dashboard.php">Voltar</a></div>

  <div class="card">
    <form method="get">
      <label>Selecione o item</label>
      <select name="item_id" onchange="this.form.submit()">
        <option value="">--</option>
        <?php foreach($items as $it): ?>
          <option value="<?=$it['id']?>" <?=$item_id===(int)$it['id']?'selected':''?>><?=h($it['name'])?></option>
        <?php endforeach; ?>
      </select>
    </form>
  </div>

  <?php if($item_id>0): ?>
    <form class="card" method="post">
      <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
      <input type="hidden" name="mode" value="add">
      <input type="hidden" name="item_id" value="<?=$item_id?>">
      <div class="grid grid3">
        <div><label>Cor</label><input name="variant_name" required placeholder="Ex: Dourado"></div>
        <div><label>Estoque</label><input type="number" name="stock_qty" value="0" min="0" required></div>
        <div style="display:flex; align-items:end"><button>Adicionar/Atualizar</button></div>
      </div>
      <div class="small">Dica: se a cor já existir, ela atualiza o estoque.</div>
    </form>

    <table class="table">
      <thead><tr><th>Cor</th><th>Estoque</th><th></th></tr></thead>
      <tbody>
      <?php foreach($vars as $v): ?>
        <tr>
          <td><b><?=h($v['variant_name'])?></b></td>
          <td><?= (int)$v['stock_qty']?></td>
          <td>
            <form method="post" style="display:inline">
              <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
              <input type="hidden" name="mode" value="del">
              <input type="hidden" name="id" value="<?= (int)$v['id'] ?>">
              <button onclick="return confirm('Excluir cor?')" style="width:auto; padding:8px 12px">Excluir</button>
            </form>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  <?php endif; ?>
</div></body></html>
