<?php
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/helpers.php';
require_once __DIR__.'/../includes/csrf.php';
require_once __DIR__.'/../includes/upload.php';
require_login_admin();

if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  $mode = $_POST['mode'] ?? 'add';

  if ($mode==='add') {
    $name = trim($_POST['name'] ?? '');
    if ($name!=='') {
      $pdo->prepare("INSERT INTO themes (name, active) VALUES (?,1)")->execute([$name]);
      $id = (int)$pdo->lastInsertId();
      try {
        $img = save_uploaded_image('image', 'theme_');
        if ($img) $pdo->prepare("UPDATE themes SET image_path=? WHERE id=?")->execute([$img,$id]);
      } catch (Exception $e) {
        flash_set($e->getMessage(), 'err');
      }
      flash_set("Tema cadastrado.");
      redirect('themes.php');
    }
  }

  if ($mode==='edit') {
    $id = (int)($_POST['id'] ?? 0);
    $name = trim($_POST['name'] ?? '');
    $active = isset($_POST['active']) ? 1 : 0;
    if ($id>0 && $name!=='') {
      $pdo->prepare("UPDATE themes SET name=?, active=? WHERE id=?")->execute([$name,$active,$id]);
      try {
        $img = save_uploaded_image('image', 'theme_');
        if ($img) $pdo->prepare("UPDATE themes SET image_path=? WHERE id=?")->execute([$img,$id]);
      } catch (Exception $e) {
        flash_set($e->getMessage(), 'err');
      }
      flash_set("Tema atualizado.");
      redirect('themes.php');
    }
  }

  if ($mode==='delete') {
    $id = (int)($_POST['id'] ?? 0);
    if ($id>0) {
      $pdo->prepare("DELETE FROM themes WHERE id=?")->execute([$id]);
      flash_set("Tema removido.");
      redirect('themes.php');
    }
  }
}

$themes = $pdo->query("SELECT id,name,image_path,active FROM themes ORDER BY active DESC, name ASC")->fetchAll();
$flash = flash_get();
?><!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="../assets/style.css"><title>Temas</title></head><body>
<header class="brandbar">
  <a class="logo" href="dashboard.php">
    <img src="../assets/logo.webp" alt="Flor de Liz">
    <div class="logo-text">
      <div class="logo-title">Flor de Liz</div>
      <div class="logo-sub">Administração</div>
    </div>
  </a>
  <div class="brand-actions">
    <a class="badge" href="dashboard.php">Dashboard</a> <a class="badge" href="orders.php">Pedidos</a> <a class="badge" href="logout.php">Sair</a>
  </div>
</header>

<div class="container">
  <div class="top">
    <div>
      <h2>Temas</h2>
      <div class="small">Cadastre os temas com imagem. Eles aparecerão para o cliente escolher após selecionar o kit.</div>
    </div>
    <div>
      <a class="badge" href="items.php">Itens</a>
      <a class="badge" href="variants.php">Cores</a>
      <a class="badge" href="themes.php">Temas</a>
      <a class="badge" href="kits.php">Kits</a>
      <a class="badge" href="orders.php">Pedidos</a>
      <a class="badge" href="logout.php">Sair</a>
    </div>
  </div>

  <?php if(!empty($flash['msg'])): ?>
    <div class="card"><?=h($flash['msg'])?></div>
  <?php endif; ?>

  <div class="card">
    <h3 style="margin-top:0">Adicionar tema</h3>
    <form method="post" enctype="multipart/form-data">
      <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
      <input type="hidden" name="mode" value="add">
      <div class="grid grid2">
        <div>
          <label>Nome</label>
          <input name="name" required placeholder="Ex: Minnie Rosa, Safari, Unicórnio...">
        </div>
        <div>
          <label>Imagem (1)</label>
          <input type="file" name="image" accept="image/*">
        </div>
      </div>
      <button style="margin-top:10px">Salvar</button>
      <div class="small" style="margin-top:8px">Dica: use imagens boas. O sistema corta em <b>cover</b> para ficar padronizado.</div>
    </form>
  </div>

  <?php foreach($themes as $t): ?>
    <div class="card">
      <div class="top" style="align-items:flex-start; gap:18px">
        <div style="flex:1">
          <form method="post" enctype="multipart/form-data">
            <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
            <input type="hidden" name="mode" value="edit">
            <input type="hidden" name="id" value="<?=$t['id']?>">

            <label>Nome</label>
            <input name="name" value="<?=h($t['name'])?>" required>

            <div style="display:flex; gap:10px; align-items:center; margin-top:10px">
              <label style="margin:0; display:flex; gap:8px; align-items:center">
                <input type="checkbox" name="active" <?=((int)$t['active']===1?'checked':'')?>>
                Ativo
              </label>
              <div class="small">ID: <?=$t['id']?></div>
            </div>

            <label style="margin-top:10px">Trocar imagem</label>
            <input type="file" name="image" accept="image/*">

            <button style="margin-top:10px">Atualizar</button>
          </form>

          <form method="post" style="margin-top:10px" onsubmit="return confirm('Remover tema?');">
            <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
            <input type="hidden" name="mode" value="delete">
            <input type="hidden" name="id" value="<?=$t['id']?>">
            <button type="submit" style="background:linear-gradient(90deg,#ef4444,#b91c1c)">Excluir</button>
          </form>
        </div>

        <div style="min-width:220px">
          <?php if(!empty($t['image_path'])): ?>
            <img class="kit-cover" style="height:160px" src="../<?=h($t['image_path'])?>" alt="<?=h($t['name'])?>">
          <?php else: ?>
            <div class="small">Sem imagem.</div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  <?php endforeach; ?>

  <?php if(!$themes): ?>
    <div class="card">Nenhum tema cadastrado.</div>
  <?php endif; ?>

</div>
</body></html>
