<?php
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/helpers.php';
require_login_admin();

$q_status = $_GET['status'] ?? '';
$q_date   = $_GET['date'] ?? '';
$q_pay    = $_GET['pay'] ?? '';

$params = [];
$where = "1=1";

if ($q_status !== '') { $where .= " AND o.status=?"; $params[] = $q_status; }
if ($q_pay !== '')    { $where .= " AND o.payment_status=?"; $params[] = $q_pay; }
if ($q_date !== '')   { $where .= " AND o.event_date=?"; $params[] = $q_date; }

$sql = "
  SELECT o.code, o.event_date, o.pickup_at, o.return_at, o.status, o.total_value, o.deposit_required,
         o.payment_status, c.full_name, c.phone, k.name AS kit_name, t.name AS theme_name
  FROM orders o
  JOIN customers c ON c.id=o.customer_id
  JOIN kits k ON k.id=o.kit_id
  LEFT JOIN themes t ON t.id=o.theme_id
  WHERE $where
  ORDER BY o.pickup_at DESC
  LIMIT 200
";
$st = $pdo->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll();

$statuses = ['pending','confirmed','picked_up','returned','canceled'];
$pays = ['unpaid','deposit_paid','paid'];
?><!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="../assets/style.css"><title>Pedidos</title></head><body>
<header class="brandbar">
  <a class="logo" href="dashboard.php">
    <img src="../assets/logo.webp" alt="Flor de Liz">
    <div class="logo-text">
      <div class="logo-title">Flor de Liz</div>
      <div class="logo-sub">Mini pegue e monte</div>
    </div>
  </a>
  <div class="brand-actions">
    <a class="badge" href="dashboard.php">Dashboard</a> <a class="badge" href="orders.php">Pedidos</a> <a class="badge" href="logout.php">Sair</a>
  </div>
</header>
<div class="container">
  <div class="top">
    <div><h2>Pedidos</h2><div class="small">Agenda e pagamentos</div></div>
    <div>
      <a class="badge" href="dashboard.php">Dashboard</a>
      <a class="badge" href="logout.php">Sair</a>
    </div>
  </div>

  <form class="card" method="get">
    <div class="grid grid2">
      <div><label>Data do evento</label><input type="date" name="date" value="<?=h($q_date)?>"></div>
      <div>
        <label>Status</label>
        <select name="status">
          <option value="">Todos</option>
          <?php foreach($statuses as $s): ?>
            <option value="<?=h($s)?>" <?=$q_status===$s?'selected':''?>><?=h($s)?></option>
          <?php endforeach; ?>
        </select>
      </div>
    </div>
    <div class="grid grid2" style="margin-top:10px">
      <div>
        <label>Pagamento</label>
        <select name="pay">
          <option value="">Todos</option>
          <?php foreach($pays as $p): ?>
            <option value="<?=h($p)?>" <?=$q_pay===$p?'selected':''?>><?=h($p)?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div style="display:flex; align-items:end; gap:10px">
        <button>Filtrar</button>
        <a class="badge" href="orders.php">Limpar</a>
      </div>
    </div>
  </form>

  <?php foreach($rows as $r): ?>
    <div class="card">
      <div class="top">
        <div>
          <div class="badge"><?=h($r['status'])?></div>
          <div class="badge"><?=h($r['payment_status'])?></div>
          <div style="margin-top:8px"><b><?=h($r['code'])?></b> — <?=h($r['kit_name'])?><?php if(!empty($r['theme_name'])): ?> <span class="small">• Tema: <?=h($r['theme_name'])?></span><?php endif; ?></div>
          <div class="small">
            Cliente: <?=h($r['full_name'])?> (<?=h($r['phone'])?>)<br>
            Retirada: <b><?=h($r['pickup_at'])?></b> • Devolução: <b><?=h($r['return_at'])?></b><br>
            Total: <b>R$ <?=number_format((float)$r['total_value'],2,',','.')?></b> •
            Sinal: <b>R$ <?=number_format((float)$r['deposit_required'],2,',','.')?></b>
          </div>
        </div>
        <div style="display:flex; flex-direction:column; gap:8px; min-width:160px">
          <a class="badge" href="order_view.php?code=<?=h($r['code'])?>">Abrir</a>
        </div>
      </div>
    </div>
  <?php endforeach; ?>

  <?php if(!$rows): ?><div class="card">Nenhum pedido encontrado.</div><?php endif; ?>
</div></body></html>
