<?php
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/helpers.php';
require_once __DIR__.'/../includes/csrf.php';
require_login_admin();

$code = $_GET['code'] ?? '';
$st = $pdo->prepare("
  SELECT o.*, c.full_name, c.phone, k.name AS kit_name, t.name AS theme_name
  FROM orders o
  JOIN customers c ON c.id=o.customer_id
  JOIN kits k ON k.id=o.kit_id
LEFT JOIN themes t ON t.id=o.theme_id
  WHERE o.code=? LIMIT 1
");
$st->execute([$code]);
$o = $st->fetch();
if(!$o) exit("Pedido não encontrado.");
$order_id = (int)$o['id'];

$st2 = $pdo->prepare("
  SELECT i.name AS item_name, v.variant_name, oc.qty
  FROM order_customizations oc
  JOIN items i ON i.id=oc.item_id
  JOIN item_variants v ON v.id=oc.variant_id
  WHERE oc.order_id=?
  ORDER BY oc.id ASC
");
$st2->execute([$order_id]);
$custom = $st2->fetchAll();

$admin_msg =
"Pedido {$o['code']} - {$o['kit_name']}\n".
"Cliente: {$o['full_name']} ({$o['phone']})\n".
"Tema: {$o['theme_text']}\n".
"Retirada: {$o['pickup_at']} | Devolução: {$o['return_at']}\n".
"Total: R$ ".number_format((float)$o['total_value'],2,',','.').
" | Sinal: R$ ".number_format((float)$o['deposit_required'],2,',','.')."\n".
"Status: {$o['status']} | Pagamento: {$o['payment_status']}";

$client_msg =
"Olá, {$o['full_name']}! 👋\n".
"Seu pedido {$o['code']} ({$o['kit_name']}) foi registrado.\n".
"Retirada: {$o['pickup_at']} | Devolução: {$o['return_at']}\n".
"Tema: {$o['theme_text']}\n".
"Total: R$ ".number_format((float)$o['total_value'],2,',','.').
" | Sinal (50%): R$ ".number_format((float)$o['deposit_required'],2,',','.')."\n".
"Assim que efetuar o sinal, me envie o comprovante por aqui. 💖";

if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  $action = $_POST['action'] ?? '';

  if ($action === 'set_status') {
    $new = $_POST['status'] ?? 'pending';
    $pdo->prepare("UPDATE orders SET status=? WHERE id=?")->execute([$new,$order_id]);
    redirect("order_view.php?code=".urlencode($code));
  }

  if ($action === 'set_payment') {
    $new = $_POST['payment_status'] ?? 'unpaid';
    $pdo->prepare("UPDATE orders SET payment_status=? WHERE id=?")->execute([$new,$order_id]);
    redirect("order_view.php?code=".urlencode($code));
  }

  if ($action === 'mark_paid_value') {
    $val = (float)str_replace(',','.', $_POST['paid_value'] ?? '0');
    $pdo->prepare("UPDATE orders SET paid_value=?, paid_at=? WHERE id=?")->execute([$val, now_br(), $order_id]);
    redirect("order_view.php?code=".urlencode($code));
  }
}
?><!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="../assets/style.css"><title>Pedido <?=h($o['code'])?></title></head><body>
<header class="brandbar">
  <a class="logo" href="dashboard.php">
    <img src="../assets/logo.webp" alt="Flor de Liz">
    <div class="logo-text">
      <div class="logo-title">Flor de Liz</div>
      <div class="logo-sub">Mini pegue e monte</div>
    </div>
  </a>
  <div class="brand-actions">
    <a class="badge" href="dashboard.php">Dashboard</a> <a class="badge" href="orders.php">Pedidos</a> <a class="badge" href="logout.php">Sair</a>
  </div>
</header>
<div class="container">
  <div class="top">
    <div><h2>Pedido <?=h($o['code'])?></h2><div class="small"><?=h($o['kit_name'])?></div></div>
    <div>
      <a class="badge" href="orders.php">Voltar</a>
      <a class="badge" href="dashboard.php">Dashboard</a>
    </div>
  </div>

  <div class="card">
    <div class="top">
      <div>
        <div class="badge"><?=h($o['status'])?></div>
        <div class="badge"><?=h($o['payment_status'])?></div>
        <h3 style="margin:10px 0 6px 0"><?=h($o['kit_name'])?></h3>
        <div class="small">
          Cliente: <b><?=h($o['full_name'])?></b> • <?=h($o['phone'])?><br>
          Tema: <b><?=h(!empty($o['theme_name'])?$o['theme_name']:$o['theme_text'])?></b><br>
          Retirada: <b><?=h($o['pickup_at'])?></b> • Devolução: <b><?=h($o['return_at'])?></b><br>
          Total: <b>R$ <?=number_format((float)$o['total_value'],2,',','.')?></b> •
          Sinal(50%): <b>R$ <?=number_format((float)$o['deposit_required'],2,',','.')?></b>
        </div>
      </div>
      <div style="display:flex; flex-direction:column; gap:10px; min-width:220px">
        <a class="badge" target="_blank" href="<?=h(wa_link((string)$o['phone'], $client_msg))?>">WhatsApp cliente</a>
        <a class="badge" target="_blank" href="<?=h(wa_link((string)$o['phone'], $admin_msg))?>">WhatsApp (resumo)</a>
      </div>
    </div>
  </div>

  <div class="card">
    <h3 style="margin-top:0">Cores escolhidas</h3>
    <?php if(!$custom): ?>
      <div class="small">Sem itens customizáveis.</div>
    <?php else: ?>
      <?php foreach($custom as $c): ?>
        <div class="small">• <?=h($c['item_name'])?>: <b><?=h($c['variant_name'])?></b> (<?= (int)$c['qty']?>)</div>
      <?php endforeach; ?>
    <?php endif; ?>
  </div>

  <div class="card" id="acoes">
    <h3 style="margin-top:0">Ações</h3>

    <form method="post" style="margin-bottom:12px">
      <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
      <input type="hidden" name="action" value="set_status">
      <label>Status do pedido</label>
      <select name="status">
        <?php foreach(['pending','confirmed','picked_up','returned','canceled'] as $s): ?>
          <option value="<?=h($s)?>" <?=$o['status']===$s?'selected':''?>><?=h($s)?></option>
        <?php endforeach; ?>
      </select>
      <button style="margin-top:10px">Atualizar status</button>
    </form>

    <form method="post" style="margin-bottom:12px">
      <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
      <input type="hidden" name="action" value="set_payment">
      <label>Pagamento</label>
      <select name="payment_status">
        <?php foreach(['unpaid','deposit_paid','paid'] as $p): ?>
          <option value="<?=h($p)?>" <?=$o['payment_status']===$p?'selected':''?>><?=h($p)?></option>
        <?php endforeach; ?>
      </select>
      <button style="margin-top:10px">Atualizar pagamento</button>
    </form>

    <form method="post">
      <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
      <input type="hidden" name="action" value="mark_paid_value">
      <label>Valor pago (controle)</label>
      <input name="paid_value" value="<?=h((string)$o['paid_value'])?>" placeholder="ex: 49.99">
      <button style="margin-top:10px">Salvar valor pago</button>
      <div class="small">Dica: quando sinal cair, marque “deposit_paid”. Quando total pago, marque “paid”.</div>
    </form>
  </div>
</div>
</body></html>
