<?php
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/helpers.php';
require_once __DIR__.'/../includes/csrf.php';
require_once __DIR__.'/../includes/upload.php';
require_login_admin();

if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  $mode = $_POST['mode'] ?? '';

  if ($mode==='add') {
    $name = trim($_POST['name']??'');
    $price = (float)str_replace(',','.', $_POST['price']??'0');
    if($name!=='') {
      $pdo->prepare("INSERT INTO kits (name, price, active) VALUES (?,?,1)")->execute([$name,$price]);
      $id = (int)$pdo->lastInsertId();
      try {
        $img = save_uploaded_image('image', 'kit_');
        if ($img) {
          $pdo->prepare("UPDATE kits SET photo_path=? WHERE id=?")->execute([$img,$id]);
        }
      } catch (Exception $e) {
        // Se imagem falhar, não impede cadastro do kit
      }
    }
    redirect('kits.php');
  }

  if ($mode==='img') {
    $id = (int)($_POST['id']??0);
    try {
      $img = save_uploaded_image('image', 'kit_');
      if ($img) $pdo->prepare("UPDATE kits SET photo_path=? WHERE id=?")->execute([$img,$id]);
    } catch (Exception $e) {
      // silencioso
    }
    redirect('kits.php');
  }

  if ($mode==='del') {
    $id = (int)($_POST['id']??0);
    $pdo->prepare("DELETE FROM kits WHERE id=?")->execute([$id]);
    $pdo->prepare("DELETE FROM kit_items WHERE kit_id=?")->execute([$id]);
    redirect('kits.php');
  }
}

$kits = $pdo->query("SELECT * FROM kits ORDER BY price ASC")->fetchAll();
?><!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="../assets/style.css"><title>Kits</title></head><body>
<header class="brandbar">
  <a class="logo" href="dashboard.php">
    <img src="../assets/logo.webp" alt="Flor de Liz">
    <div class="logo-text">
      <div class="logo-title">Flor de Liz</div>
      <div class="logo-sub">Mini pegue e monte</div>
    </div>
  </a>
  <div class="brand-actions">
    <a class="badge" href="dashboard.php">Dashboard</a> <a class="badge" href="orders.php">Pedidos</a> <a class="badge" href="logout.php">Sair</a>
  </div>
</header>
<div class="container">
  <div class="top"><h2>Kits</h2><a class="badge" href="dashboard.php">Voltar</a></div>

  <form class="card" method="post" enctype="multipart/form-data">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <input type="hidden" name="mode" value="add">
    <div class="grid grid2">
      <div><label>Nome do kit</label><input name="name" required></div>
      <div><label>Preço</label><input name="price" required placeholder="99.99"></div>
    </div>
    <div style="margin-top:10px">
      <label>Imagem do kit (opcional)</label>
      <input type="file" name="image" accept="image/*">
    </div>
    <button style="margin-top:10px">Adicionar kit</button>
    <div class="small">Para editar a composição do kit, clique em “Composição”.</div>
  </form>

  <table class="table">
    <thead><tr><th>Imagem</th><th>Kit</th><th>Preço</th><th></th></tr></thead>
    <tbody>
    <?php foreach($kits as $k): ?>
      <tr>
        <td>
          <?php if(!empty($k['photo_path'])): ?>
            <img src="../<?=h($k['photo_path'])?>" alt="" class="thumb">
          <?php else: ?>
            <span class="small">-</span>
          <?php endif; ?>
        </td>
        <td><b><?=h($k['name'])?></b></td>
        <td>R$ <?=number_format((float)$k['price'],2,',','.')?></td>
        <td>
          <a class="badge" href="kit_comp.php?kit_id=<?=(int)$k['id']?>">Composição</a>
          <form method="post" enctype="multipart/form-data" style="display:inline">
            <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
            <input type="hidden" name="mode" value="img">
            <input type="hidden" name="id" value="<?= (int)$k['id'] ?>">
            <input type="file" name="image" accept="image/*" style="width:auto; display:inline-block">
            <button style="width:auto; padding:8px 12px">Salvar imagem</button>
          </form>
          <form method="post" style="display:inline">
            <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
            <input type="hidden" name="mode" value="del">
            <input type="hidden" name="id" value="<?= (int)$k['id'] ?>">
            <button onclick="return confirm('Excluir kit?')" style="width:auto; padding:8px 12px">Excluir</button>
          </form>
        </td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>
</div></body></html>
