<?php
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/helpers.php';
require_once __DIR__.'/../includes/csrf.php';
require_login_admin();

$kit_id = (int)($_GET['kit_id'] ?? 0);

$k = $pdo->prepare("SELECT * FROM kits WHERE id=? LIMIT 1");
$k->execute([$kit_id]);
$kit = $k->fetch();
if(!$kit) exit("Kit não encontrado.");

if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  $mode = $_POST['mode'] ?? '';

  if ($mode==='add') {
    $item_id = (int)($_POST['item_id'] ?? 0);
    $qty = max(1, (int)($_POST['qty'] ?? 1));
    $custom = (int)($_POST['customizable'] ?? 0) ? 1 : 0;

    if ($item_id>0) {
      $pdo->prepare("
        INSERT INTO kit_items (kit_id, item_id, qty, customizable)
        VALUES (?,?,?,?)
        ON DUPLICATE KEY UPDATE qty=VALUES(qty), customizable=VALUES(customizable)
      ")->execute([$kit_id,$item_id,$qty,$custom]);
    }
    redirect('kit_comp.php?kit_id='.$kit_id);
  }

  if ($mode==='del') {
    $id = (int)($_POST['id'] ?? 0);
    $pdo->prepare("DELETE FROM kit_items WHERE id=? AND kit_id=?")->execute([$id,$kit_id]);
    redirect('kit_comp.php?kit_id='.$kit_id);
  }
}

$items = $pdo->query("SELECT id,name,category FROM items ORDER BY category,name")->fetchAll();
$comp = $pdo->prepare("
  SELECT ki.id, ki.qty, ki.customizable, i.name, i.category
  FROM kit_items ki JOIN items i ON i.id=ki.item_id
  WHERE ki.kit_id=?
  ORDER BY ki.id ASC
");
$comp->execute([$kit_id]);
$rows = $comp->fetchAll();
?><!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="../assets/style.css"><title>Composição - <?=h($kit['name'])?></title></head><body>
<header class="brandbar">
  <a class="logo" href="dashboard.php">
    <img src="../assets/logo.webp" alt="Flor de Liz">
    <div class="logo-text">
      <div class="logo-title">Flor de Liz</div>
      <div class="logo-sub">Mini pegue e monte</div>
    </div>
  </a>
  <div class="brand-actions">
    <a class="badge" href="dashboard.php">Dashboard</a> <a class="badge" href="orders.php">Pedidos</a> <a class="badge" href="logout.php">Sair</a>
  </div>
</header>
<div class="container">
  <div class="top">
    <div>
      <h2>Composição</h2>
      <div class="small"><?=h($kit['name'])?> • R$ <?=number_format((float)$kit['price'],2,',','.')?></div>
    </div>
    <a class="badge" href="kits.php">Voltar</a>
  </div>

  <form class="card" method="post">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <input type="hidden" name="mode" value="add">
    <div class="grid grid3">
      <div>
        <label>Item</label>
        <select name="item_id" required>
          <option value="">Selecione</option>
          <?php foreach($items as $it): ?>
            <option value="<?=$it['id']?>"><?=h($it['category'])?> • <?=h($it['name'])?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label>Quantidade</label>
        <input type="number" name="qty" value="1" min="1" required>
      </div>
      <div>
        <label>Escolha de cor?</label>
        <select name="customizable">
          <option value="0">Não</option>
          <option value="1">Sim</option>
        </select>
        <button style="margin-top:10px">Adicionar/Atualizar</button>
      </div>
    </div>
    <div class="small">Marque “Sim” para bandejas, jarros, mini cakes e boleiras.</div>
  </form>

  <table class="table">
    <thead><tr><th>Item</th><th>Qtd</th><th>Cor?</th><th></th></tr></thead>
    <tbody>
      <?php foreach($rows as $r): ?>
        <tr>
          <td><?=h($r['category'])?> • <b><?=h($r['name'])?></b></td>
          <td><?= (int)$r['qty']?></td>
          <td><?= $r['customizable'] ? '<span class="badge">Sim</span>' : '<span class="badge">Não</span>' ?></td>
          <td>
            <form method="post" style="display:inline">
              <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
              <input type="hidden" name="mode" value="del">
              <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
              <button onclick="return confirm('Remover item do kit?')" style="width:auto; padding:8px 12px">Remover</button>
            </form>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div></body></html>
