<?php
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/helpers.php';
require_once __DIR__.'/../includes/csrf.php';
require_once __DIR__.'/../includes/upload.php';
require_login_admin();

$cats = [
 'panel'=>'Painel','table'=>'Mesa','tray'=>'Bandeja','jar'=>'Jarro',
 'mini_cake'=>'Mini cake','cake_stand'=>'Boleira','accessory'=>'Acessório'
];

if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  $mode = $_POST['mode'] ?? 'add';

  if ($mode==='add') {
    $name = trim($_POST['name']??'');
    $cat  = $_POST['category']??'accessory';
    $price = (float)str_replace(',','.', $_POST['price']??'0');
    if($name!=='') {
      $pdo->prepare("INSERT INTO items (name, category, price, active) VALUES (?,?,?,1)")
          ->execute([$name,$cat,$price]);
      $id = (int)$pdo->lastInsertId();
      try {
        $img = save_uploaded_image('image', 'item_');
        if ($img) {
          $pdo->prepare("UPDATE items SET image_path=? WHERE id=?")->execute([$img,$id]);
        }
      } catch (Exception $e) {
        // Se imagem falhar, não impede o cadastro do item
      }
    }
    redirect('items.php');
  }

  if ($mode==='img') {
    $id = (int)($_POST['id']??0);
    try {
      $img = save_uploaded_image('image', 'item_');
      if ($img) $pdo->prepare("UPDATE items SET image_path=? WHERE id=?")->execute([$img,$id]);
    } catch (Exception $e) {
      // silencioso
    }
    redirect('items.php');
  }

  if ($mode==='del') {
    $id = (int)($_POST['id']??0);
    $pdo->prepare("DELETE FROM items WHERE id=?")->execute([$id]);
    redirect('items.php');
  }
}

$rows = $pdo->query("SELECT * FROM items ORDER BY id DESC")->fetchAll();
?><!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="../assets/style.css"><title>Itens</title></head><body>
<header class="brandbar">
  <a class="logo" href="dashboard.php">
    <img src="../assets/logo.webp" alt="Flor de Liz">
    <div class="logo-text">
      <div class="logo-title">Flor de Liz</div>
      <div class="logo-sub">Mini pegue e monte</div>
    </div>
  </a>
  <div class="brand-actions">
    <a class="badge" href="dashboard.php">Dashboard</a> <a class="badge" href="orders.php">Pedidos</a> <a class="badge" href="logout.php">Sair</a>
  </div>
</header>
<div class="container">
  <div class="top"><h2>Itens</h2><a class="badge" href="dashboard.php">Voltar</a></div>

  <form class="card" method="post" enctype="multipart/form-data">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <input type="hidden" name="mode" value="add">
    <div class="grid grid3">
      <div><label>Nome</label><input name="name" required></div>
      <div><label>Categoria</label>
        <select name="category">
          <?php foreach($cats as $k=>$v): ?><option value="<?=$k?>"><?=h($v)?></option><?php endforeach; ?>
        </select>
      </div>
      <div><label>Preço (opcional)</label><input name="price" placeholder="0.00"></div>
    </div>
    <div style="margin-top:10px">
      <label>Imagem do item (opcional)</label>
      <input type="file" name="image" accept="image/*">
    </div>
    <button style="margin-top:10px">Adicionar item</button>
    <div class="small">Depois cadastre as cores em “Cores”.</div>
  </form>

  <table class="table">
    <thead><tr>
      <th>ID</th><th>Imagem</th><th>Nome</th><th>Categoria</th><th>Preço</th><th></th>
    </tr></thead>
    <tbody>
    <?php foreach($rows as $r): ?>
      <tr>
        <td><?= (int)$r['id'] ?></td>
        <td>
          <?php if(!empty($r['image_path'])): ?>
            <img src="../<?=h($r['image_path'])?>" alt="" class="thumb">
          <?php else: ?>
            <span class="small">-</span>
          <?php endif; ?>
        </td>
        <td><?= h($r['name']) ?></td>
        <td><?= h($r['category']) ?></td>
        <td>R$ <?= number_format((float)$r['price'],2,',','.') ?></td>
        <td>
          <a class="badge" href="variants.php?item_id=<?= (int)$r['id'] ?>">Cores</a>
          <form method="post" enctype="multipart/form-data" style="display:inline">
            <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
            <input type="hidden" name="mode" value="img">
            <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
            <input type="file" name="image" accept="image/*" style="width:auto; display:inline-block">
            <button style="width:auto; padding:8px 12px">Salvar imagem</button>
          </form>
          <form method="post" style="display:inline">
            <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
            <input type="hidden" name="mode" value="del">
            <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
            <button onclick="return confirm('Remover item?')" style="width:auto; padding:8px 12px">Excluir</button>
          </form>
        </td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>
</div></body></html>
