<?php
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/helpers.php';
require_login_admin();

$next = $pdo->query("
  SELECT o.code, o.pickup_at, o.status, o.payment_status, k.name AS kit_name
  FROM orders o
  JOIN kits k ON k.id=o.kit_id
  ORDER BY o.pickup_at ASC
  LIMIT 10
")->fetchAll();
?><!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="../assets/style.css"><title>Dashboard</title></head><body>
<header class="brandbar">
  <a class="logo" href="dashboard.php">
    <img src="../assets/logo.webp" alt="Flor de Liz">
    <div class="logo-text">
      <div class="logo-title">Flor de Liz</div>
      <div class="logo-sub">Mini pegue e monte</div>
    </div>
  </a>
  <div class="brand-actions">
    <a class="badge" href="dashboard.php">Dashboard</a> <a class="badge" href="orders.php">Pedidos</a> <a class="badge" href="logout.php">Sair</a>
  </div>
</header>
<div class="container">
  <div class="top">
    <div>
      <h2>Dashboard</h2>
      <div class="small">Flor de Liz • Administração</div>
    </div>
    <div>
      <a class="badge" href="items.php">Itens</a>
      <a class="badge" href="variants.php">Cores</a>
      <a class="badge" href="themes.php">Temas</a>
      <a class="badge" href="kits.php">Kits</a>
      <a class="badge" href="orders.php">Pedidos</a>
      <a class="badge" href="logout.php">Sair</a>
    </div>
  </div>

  <div class="card">
    <h3 style="margin-top:0">Próximos pedidos</h3>
    <?php foreach($next as $o): ?>
      <div class="small">
        • <a href="order_view.php?code=<?=h($o['code'])?>"><?=h($o['code'])?></a>
        — <?=h($o['pickup_at'])?> — <b><?=h($o['status'])?></b> — <span class="badge"><?=h($o['payment_status'])?></span>
        <div class="small"><?=h($o['kit_name'])?></div>
      </div>
      <hr>
    <?php endforeach; ?>
    <?php if(!$next): ?><div class="small">Sem pedidos.</div><?php endif; ?>
  </div>
</div></body></html>
